<?php require 'includes/header.php'; ?>

<style>
  .table-container {
    width: 100%;
    overflow-x: auto;
    margin-top: 30px;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    white-space: nowrap;
    font-size: 14px;
  }

  th,
  td {
    border: 1px solid #888;
    padding: 10px;
    text-align: center;
  }

  th {
    background-color: #004d66;
    color: white;
  }

  .category-header {
    background-color: #fff;
    font-weight: bold;
  }
  .g-4, .gy-4 {
    --bs-gutter-y: 0.5rem;
}
</style>

<main class="main">
  <!-- Page Title -->
 

  <section id="contact" class="contact section">
    <div class="container sub-header-titel aos-init aos-animate" data-aos="fade-up">
      <h2>Schedule of Fees</h2>

      <div class="row gy-4">
        <div style="overflow-x:auto;">
          <div class="table-container">
            <table>
              <thead>
                <tr>
                  <th colspan="4">Conference Registration - Cost Inclusive of 18% GST</th>
                </tr>
                <tr>
                  <th>Category</th>
                  <th>Till 31st Sep</th>
                  <th>Till 10th Nov</th>
                  <th>11th Nov Onwards</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>Delegate</td>
                  <td>11210</td>
                  <td>12390</td>
                  <td>14750</td>
                </tr>
                <tr>
                  <td>PG Students</td>
                  <td>7670</td>
                  <td>8260</td>
                  <td>8850</td>
                </tr>
              </tbody>
            </table>
          </div>
          <div class="table-container">

            <h2>Workshop Registration </h2>
            <table>
              <thead>
                <tr>
                  <th colspan="4">Friday - 14th November 2025<br>Pre-Congress Workshop</th>
                </tr>
                <tr>
                  <th>Morning Workshops<br>9.00 am - 1.00 pm</th>
                  <th>Afternoon Workshops<br>2.00 pm - 6.00 pm</th>
                  <th colspan="2"> </th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>Adolescent Health</td>
                  <td>Family Welfare and Contraception</td>
                  <td colspan="2"></td>
                </tr>
                <tr>
                  <td>APH &amp; PPH</td>
                  <td>Fetal Medicine and Genetics</td>
                  <td colspan="2"></td>
                </tr>
                <tr>
                  <td>Cosmetic Gynecology</td>
                  <td>Gynac Endoscopy</td>
                  <td colspan="2"></td>
                </tr>
                <tr>
                  <td>Infertility &amp; Endocrinology</td>
                  <td>Gynac Oncology</td>
                  <td colspan="2"></td>
                </tr>
                <tr>
                  <td>Poise Workshop by GE</td>
                  <td>High Risk Obstetrics</td>
                  <td colspan="2"></td>
                </tr>
              </tbody>
            </table>
          </div>

          <br>

          <div class="table-container">
            <table>
              <thead>
                <tr>
                  <th colspan="4">Only Workshop Registration - Cost Inclusive of 18% GST<br>
                    Morning Workshops (9.00 am - 1.00 pm) / Afternoon Workshops (2.00 pm - 6.00 pm)
                  </th>
                </tr>
                <tr>
                  <th>Category</th>
                  <th>Till 31st Sep</th>
                  <th>Till 10th Nov</th>
                  <th>11th Nov Onwards</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>Delegate</td>
                  <td>INR 3540</td>
                  <td>INR 4130</td>
                  <td>INR 4720</td>
                </tr>
                <tr>
                  <td>PG Students</td>
                  <td>INR 2891</td>
                  <td>INR 3245</td>
                  <td>INR 3540</td>
                </tr>
              </tbody>
            </table>
          </div>

          <br>

          <div class="table-container">
            <table>
              <thead>
                <tr>
                  <th colspan="4">Full Day Workshops<br>9.00 am - 6.00 pm</th>
                </tr>
                <tr>
                  <th colspan="4">Hysteroscopy Stimulator</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td colspan="2">Hysteroscopy Stimulator</td>
                  <td colspan="2">INR 20000</td>
                </tr>
                <tr>
                  <td colspan="4">
                    This workshop offers a hands-on hysteroscopy simulation experience. Each day, multiple 30-minute slots between 9.00 am to 6.00 pm will be available and allocated by the organizing committee.
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <br>

          <div class="table-container">
            <table>
              <thead>
                <tr>
                  <th colspan="4">Evening Workshop<br>6.00 pm - 8.00 pm</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td colspan="4">Learn the pathway to publication with Artificial Intelligence</td>
                </tr>
              </tbody>
            </table>
          </div>

          <br><br>
        </div>


        <h2>Accommodation at STAR Sampoorna 2025</h2>

        <p>
          The FOGSI Presidential Conference – STAR Sampoorna will be held at JW Marriott, Pune from November 14 to 16, 2025.
          Accommodation is available in two categories:
        </p>
        <ul style="padding-left: 40px;">
          <li>Single Occupancy</li>
          <li>Twin Sharing Basis</li>
        </ul>

        <p>Participants can choose between:</p>
        <ul style="padding-left: 40px;">
          <li>1 Night Stay: Check-in on 15th November 2025 (Saturday), Check-out on 16th November 2025 (Sunday)</li>
          <li>2 Nights Stay: Check-in on 14th November 2025 (Friday), Check-out on 16th November 2025 (Sunday)</li>
        </ul>

        <div class="table-container">
          <table>
            <thead>
              <tr>
                <th colspan="5">Accommodation Fee Schedule</th>
              </tr>
              <tr>
                <th>Category</th>
                <th>Duration</th>
                <th>Base Fee (INR)</th>
                <th>GST (18%)</th>
                <th>Total Fee (INR)</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Single Occupancy</td>
                <td>1 Night</td>
                <td>15,000</td>
                <td>2,700</td>
                <td>17,700</td>
              </tr>
              <tr>
                <td>Twin Sharing Basis</td>
                <td>1 Night</td>
                <td>9,000</td>
                <td>1,620</td>
                <td>10,620 (Per Person)</td>
              </tr>
              <tr>
                <td>Single Occupancy</td>
                <td>2 Nights</td>
                <td>30,000</td>
                <td>5,400</td>
                <td>35,400</td>
              </tr>
              <tr>
                <td>Twin Sharing Basis</td>
                <td>2 Nights</td>
                <td>18,000</td>
                <td>3,240</td>
                <td>21,240 (Per Person)</td>
              </tr>
            </tbody>
          </table>

        </div>

<h5>INCLUSIONS:</h5>

        
        <p><strong>Single Occupancy</strong></p>
        <ul style="padding-left: 40px;">
          
          <li>One room for exclusive use</li>
          <li>Buffet breakfast at the hotel</li>
          <li>All applicable taxes (18% GST)</li>
          <li>Complimentary Wi-Fi</li>
          <li>Check-in at 3:00 PM and check-out at 12:00 PM (Noon)</li>
        </ul>
<h5>TWIN SHARING BASIS:</h5>
        
        <ul style="padding-left: 40px;">
          <li>One room shared between two registered delegates of the conference.</li>
          <li>Buffet breakfast for both occupants</li>
          <li>All applicable taxes (18% GST)</li>
          <li>Complimentary Wi-Fi</li>
          <li>Check-in at 3:00 PM and check-out at 12:00 PM (Noon)</li>
          <li>Roommate pairing will be done by the organizing team unless a specific roommate is indicated.</li>
          <li>To request a specific roommate, please email <strong>registration@starsampoornapune.com</strong> mentioning the delegate you wish to share with. That person must also be registered for the conference and have opted for accommodation.</li>
          <li>Requests for specific roommates must be submitted at least 2–3 weeks before the conference via email.</li>
        </ul>
<h5>RULES & REGULATIONS:</h5>
         
        <ul style="padding-left: 40px;">
          <li>Accommodation is subject to availability and will be confirmed only after full payment.</li>
          <li>Rates are applicable only for registered delegates of STAR Sampoorna 2025.</li>
          <li>Twin sharing will be assigned on a same-gender basis unless otherwise specified.</li>
          <li>Requests for specific roommates must be made via email within the specified deadline; changes after that will not be entertained.</li>
          <li>Check-in time: 3:00 PM | Check-out time: 12:00 PM (Noon)</li>
          <li>Early check-in and late check-out are subject to hotel availability and may attract additional charges.</li>
          <li>Any incidental expenses (laundry, minibar, room service, etc.) are to be borne directly by the delegate at checkout.</li>
        </ul>

      </div>

      <br>

      <div class="registration-info">
        <h5>GENERAL GUIDELINES:</h5>
        <ul style="padding-left: 40px;">
          <li>All attendees are required to complete the designated registration form individually, with one form per delegate.</li>
          <li>Please notify us promptly if you discover any discrepancies in your registration details. This will ensure a smooth and error-free registration process.</li>
          <li>Please contact us at <a href="mailto:registration@starsampoornapune.com"><strong>registration@starsampoornapune.com</strong></a>, and remember to include your Registration ID in all future correspondence.</li>
          <li>A confirmation email containing your Registration ID will be sent to all delegates who have registered.</li>
          <li>PG Students must produce a letter from HOD.</li>
          <li>Please present this confirmation at the registration counter upon arrival.</li>
          <li>Please note that the fee includes GST (Goods and Services Tax) charges.</li>
          <li>Organizer will not be responsible for any date change of the conference and any loss or theft of personal belongings.</li>
          <li>If you have any inquiries or encounter any difficulties during the registration process, please do not hesitate to contact us at <a href="mailto:registration@starsampoornapune.com"><strong>registration@starsampoornapune.com</strong></a>.</li>
        </ul>

        <h5>EVENT INFORMATION:</h5>
        <ul style="padding-left: 40px;">
          <li><strong>Conference Name:</strong> STAR SAMPOORNA CONFERENCE 2025</li>
          <li><strong>Conference Date:</strong> 14<sup>th</sup> – 16<sup>th</sup> November, 2025</li>
          <li><strong>Conference Venue:</strong> JW Marriott, Pune</li>
        </ul>

        <h5>INCLUSIONS:</h5>
        <ul style="padding-left: 40px;">
          <li>Access to the Scientific Sessions</li>
          <li>Access to the Industry Exhibitions</li>
          <li>Lunch on 15<sup>th</sup> &amp; 16<sup>th</sup> November, 2025 for conference delegates</li>
          <li>Lunch on 14<sup>th</sup>, 15<sup>th</sup> &amp; 16<sup>th</sup> November, 2025 for workshop plus conference registered delegates</li>
          <li>Conference Badge</li>
          <li>Conference Kit</li>
          <li>Conference Participation Certificate</li>
        </ul>

        <h5>CONTACT DETAILS:</h5>
        <ul style="padding-left: 40px;">
          <li><strong>Contact Person:</strong> Ms. Siddhi Sawant</li>
          <li>For any inquiries or assistance regarding registration, please contact us at the following number: <a href="tel:8928763008">8928763008</a>. Our dedicated team is available to assist you from Monday to Friday, between 10:30 am and 6:30 pm.</li>
          <li>Email – <a href="mailto:registration@starsampoornapune.com">registration@starsampoornapune.com</a></li>
        </ul>

        <h5>CANCELLATION POLICY:</h5>
        <ul style="padding-left: 40px;">
          <li>Cancellation of your conference registration can be done by writing an email to the conference secretariat at <a href="mailto:registration@starsampoornapune.com"><strong>registration@starsampoornapune.com</strong></a> clearly stating your registration number in the subject line. The email will have to be sent from the email address you used while registering.</li>
        </ul>

        <h5>PLEASE NOTE:</h5>
        <ul style="padding-left: 40px;">
          <li>Registration is non-transferable and non-refundable.</li>
          <li>Cancellations up to 31<sup>st</sup> August, 2025: 50% + GST deducted.</li>
          <li>Cancellations done post 1<sup>st</sup> September, 2025: No refund.</li>
          <li>All refunds will be provided by cheque post 6 weeks of the completion of the conference.</li>
          <li>Time stamp of email will be considered as official date of cancellation request.</li>
        </ul>
      </div>
    </div>

      <div class="row">
        <div class="col-md-4"></div>
         <div class="col-md-4 text-center d-flex align-items-center justify-content-center">
           <div class="mt-4">
             <a href="https://in.eregnow.com/ticketing/register/starsampoornaconference2025" target="_blank" class="read-more  ">
               CLICK HERE TO REGISTER<i class="bi bi-arrow-right"></i>
             </a>
           </div>
         </div>


        <div class="col-md-4"></div>
      </div>

    </div>
  </section>










</main>

<?php require 'includes/footer.php'; ?>